# -------------------------------------------------------------------------------------
# flo::plugin::Admin::Content
# -------------------------------------------------------------------------------------
# Author: Jean-Michel Hiver
# Copyright: (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# Lets an editor edit the content of a page.
# -------------------------------------------------------------------------------------
package flo::plugin::Admin::Content;
use flo::Standard;
use MKDoc::Ouch;
use strict;
use warnings;
use 5.008_000;
use Carp;

use base qw /flo::Plugin/;

sub template_path { 'admin/content' }


##
# $self->activate;
# ----------------
# Returns TRUE if this plugin can be activated, FALSE
# otherwise.
##
sub activate
{
    my $self = shift;
    return unless ($self->SUPER::activate (@_));
    my $current_document = flo::Standard::current_document();
    return $current_document->Can_Admin;
}


sub set_editor
{
    my $self = shift;
    $self->{'.editor'} = shift;
}


sub editor
{
    my $self = shift;
    $self->{'.editor'} ||= do {
	my $document = flo::Standard::current_document();
	my $editor   = new flo::Editor();
	my $xml_data = $document->{Body};
	$editor->parse_xml ($xml_data);
	$editor;
    };
    return $self->{'.editor'};
}


##
# $self->http_get;
# ----------------
# Displays the form which lets the editor choose which audiences
# the current document relates to.
##
sub http_get
{
    my $self     = shift;
    $self->render_http (
	self       => $self,
	__input__  => 'XML',
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}


##
# $self->http_post;
# -----------------
# Processes this users' POST operation.
##
sub http_post
{
    my $self   = shift;
    my $cgi    = flo::Standard::cgi();
   
    local $::MKD_flo_Editor_ETERNAL;
    $::MKD_flo_Editor_ETERNAL = undef;
    my $editor = new flo::Editor ( cgi => $cgi );

    $self->set_editor ($editor);
    {
	$self->submit()     or  return $self->http_get();
	$self->has_errors() and return $self->http_get();
	$self->redirect();
    }

    return 'TERMINATE';
}


##
# $self->redirect();
# ------------------
# Redirects the client to the current document.
##
sub redirect
{
    my $document = flo::Standard::current_document();
    my $cgix     = flo::Standard::cgi()->new();
    $cgix->delete ($_) for ($cgix->param);
    $cgix->path_info ($document->path);
    print $cgix->redirect ($cgix->self_url);    
}


##
# $self->submit();
# ----------------
# Checks if the client wants to submit.
# If it does, performs a few checks and then amend current
# document's content.
##
sub submit
{
    my $self = shift;
    $self->is_submit() or return;

    my $cgi = flo::Standard::cgi();
    my $component_count = $cgi->param ('component_count');
    (defined $component_count) or do {
	new MKDoc::Ouch 'content/count_mismatch';
	return 0;
    };
    
    my $editor = $self->editor();
    ($editor->count() != $component_count) and do {
	new MKDoc::Ouch 'content/count_mismatch';
	return 0;
    };
    
    $editor->validate() or do {
	new MKDoc::Ouch 'content/invalid';
	return 0;
    };
    
    my $document_t = flo::Standard::table ('Document');
    my $document = flo::Standard::current_document();
    $document->on_save();
    $document->{Body} = $editor->generate_xml();
    $document->set_date_last_modified ($document->now_iso());
    $document->set_editor_last_modified (flo::Standard::current_user());
    $document_t->modify ($document);
    
    my $user = flo::Standard::current_user();
    my $contributor_t = flo::Standard::table ('Contributor');
    $contributor_t->get ( Editor_ID => $user->id(), Document_ID => $document->id() ) and return 1;
    $contributor_t->insert ( Editor_ID => $user->id(), Document_ID => $document->id() );
    
    return 1;
}


##
# $class->is_submit();
# --------------------
# Returns TRUE if the client wants to amend the current document,
# FALSE otherwise.
##
sub is_submit
{
    my $cgi  = flo::Standard::cgi();
    return $cgi->param ('submit_ok');
}


1;
