package flo::plugin::Admin::UserDelete;
use strict;
use warnings;
use flo::Standard;
use flo::Record::Editor;
use base qw /flo::Plugin/;


sub activate
{
    my $self = shift;
    $self->SUPER::activate (@_) || return;
    $self->SUPER::user()->id() == 1    || return;
    
    my $cgi = $self->cgi();
    my $user_edit_id = $cgi->param ('id') || return;
    my $editor_t = flo::Standard::table ('Editor');
    $self->{user_edit} = $editor_t->get ($user_edit_id) || return;
    return if ($self->{user_edit}->id() == 1);
    return 1;
}


sub user_edit
{
    my $self = shift;
    return $self->{user_edit};
}


sub template_path { 'admin/user_delete' }


sub http_get
{
    my $self = shift;
    $self->render_http (
	self => $self,
	__output__ => 'XHTML',
       );
    
    return 'TERMINATE';
}


sub http_post
{
    my $self = shift;
    my $user_edit = $self->user_edit();

    # clear grp assignments
    my $editor_group_t = flo::Standard::table ('Editor_Grp');
    $editor_group_t->delete(Editor_ID => $user_edit->id);

    $user_edit->delete();

    use flo::plugin::Admin::UserList;
    my $userlist_p = new flo::plugin::Admin::UserList();
    
    my $cgi = flo::Standard::cgi();
    print $cgi->redirect ($userlist_p->uri());
    return 'TERMINATE';
}


1;
