# -------------------------------------------------------------------------------------
# flo::plugin::File
# -------------------------------------------------------------------------------------
# Author : Jean-Michel Hiver
# Copyright : (c) MKDoc Holdings Ltd, 2003
#
# This file is part of MKDoc. 
# 
# MKDoc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# MKDoc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with MKDoc; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Description : Performs (possibly internal) redirects to serve files.
# -------------------------------------------------------------------------------------
package flo::plugin::File;
use MKDoc::Config;
use strict;
use warnings;
use 5.008_000;
use Carp;

use base qw /flo::ComponentPlugin/;


sub run
{
    my $self = shift;    
    my $component = $self->component();
    my $location  = $component->internal_location();
    
    if ($ENV{MOD_PERL})
    {
	# require ('Apache');
	my $r = Apache->request;
	$r->internal_redirect ($location);
    }
    else
    {
	my $cgi = flo::Standard::cgi();
	$cgi->path_info ($location);
	print $cgi->redirect ($cgi->self_url);
    }
    
    return 'TERMINATE';
}


sub activate
{
    my $self = shift;
    $self->SUPER::activate() || return;
    
    my $cgi = flo::Standard::cgi();
    my $path_info = $cgi->path_info;
    $path_info =~ /\,/ and return;
    
    my $component = $self->component;
    $component->can ('internal_location') || return;
    
    return 1;
}


1;


__END__
