#!/usr/bin/perl
use strict;
use warnings;
use Test::More qw(no_plan);

use flo::editor::File;
use flo::editor::Mixin::normalize_name;

is (flo::editor::File::preferred_extension ({file => '/path/.to/hell.doc'}), 'doc');
is (flo::editor::File::preferred_extension ({file => './long/way/together.tar.gz'}), 'tar.gz');
is (flo::editor::File::preferred_extension ({file => 'mkdoc-1.6.31.tar.gz'}), 'tar.gz');
is (flo::editor::File::preferred_extension ({file => 'my.lovely.picture.jpg'}), 'jpg');
is (flo::editor::File::preferred_extension ({file => 'my.lovely.picture..jpg'}), 'jpg');
is (flo::editor::File::preferred_extension ({file => 'index.html'}), 'html');
is (flo::editor::File::preferred_extension ({file => 'my.great.american.novel.txt.gz'}), 'txt.gz');
is (flo::editor::File::preferred_extension ({file => 'my-great-american-novel.txt.gz'}), 'txt.gz');
is (flo::editor::File::preferred_extension ({file => 'someunknown.foo.gz'}), 'foo.gz');
#is (flo::editor::File::preferred_extension ({file => 'readme..'}), 'foo.gz');
#is (flo::editor::File::preferred_extension ({file => 'readme.'}), 'foo.gz');
#is (flo::editor::File::preferred_extension ({file => 'readme'}), 'foo.gz');

is (flo::editor::Mixin::normalize_name::normalize_name_nodot ('', 'mkdoc-1.6.31.tar.gz'), 'mkdoc-1-6-31');
is (flo::editor::Mixin::normalize_name::normalize_name_nodot ('', 'my.lovely.picture.jpg'), 'my-lovely-picture');
is (flo::editor::Mixin::normalize_name::normalize_name_nodot ('', 'my.lovely.picture..jpg'), 'my-lovely-picture');
is (flo::editor::Mixin::normalize_name::normalize_name_nodot ('', 'index.html'), 'index');
is (flo::editor::Mixin::normalize_name::normalize_name_nodot ('', 'my.great.american.novel.txt.gz'), 'my-great-american-novel');
is (flo::editor::Mixin::normalize_name::normalize_name_nodot ('', 'someunknown.foo.gz'), 'someunknown');
is (flo::editor::Mixin::normalize_name::normalize_name_nodot ('', 'README'), 'readme');
is (flo::editor::Mixin::normalize_name::normalize_name_nodot ('', 'readme..'), 'readme');
is (flo::editor::Mixin::normalize_name::normalize_name_nodot ('', 'readme.'), 'readme');
is (flo::editor::Mixin::normalize_name::normalize_name_nodot ('', 'readme'), 'readme');

