#!/usr/bin/perl
use strict;
use warnings;
use MKDoc;

my @IDS = @ARGV;

die "Please specify one or more Editor_ID's\n" unless @ARGV;

# make sure SITE_DIR is set since MKDoc->init needs it
die "SITE_DIR isn't set.  Please source mksetenv.sh from an installed MKDoc site ".
  "and try again.\n" 
  unless $ENV{SITE_DIR};

# initialize MKDoc, needed for database connection
MKDoc->init;

my $dbh = lib::sql::DBH->get();

for my $id (@IDS)
{

die "Can't delete admin user\n" if $id == 1;

print "Wiping references to Editor $id from Base_Document...\n";
$dbh->do(<<END);
     DELETE FROM Base_Document where Editor_ID=$id
END

print "Contributor...\n";
$dbh->do(<<END);
     DELETE FROM Contributor where Editor_ID=$id
END

print "Preference...\n";
$dbh->do(<<END);
     DELETE FROM Preference where Editor_ID=$id
END

print "Preference_Audience...\n";
$dbh->do(<<END);
     DELETE FROM Preference_Audience where Editor_ID=$id
END

print "Preference_Language...\n";
$dbh->do(<<END);
     DELETE FROM Preference_Language where Editor_ID=$id
END

print "Session...\n";
$dbh->do(<<END);
     DELETE FROM Session where Editor_ID=$id
END

print "Editor_Grp...\n";
$dbh->do(<<END);
     DELETE FROM Editor_Grp where Editor_ID=$id
END

print "Resetting to Editor 1 Document.Editor_Created_ID...\n";
$dbh->do(<<END);
     UPDATE Document SET Editor_Created_ID=1 WHERE Editor_Created_ID=$id
END

print "Resetting to Editor 1 Document.Editor_Last_Modified_ID...\n";
$dbh->do(<<END);
     UPDATE Document SET Editor_Last_Modified_ID=1 WHERE Editor_Last_Modified_ID=$id
END

print "Deleting Editor $id\n\n";
$dbh->do(<<END);
     DELETE FROM Editor WHERE ID=$id
END

}
