#!/usr/bin/perl
package MKDoc::Bin::Deltree;
use strict;
use warnings;

BEGIN {
    $ENV{MKDOC_DIR} || die 'MKDOC_DIR is not defined';
    $ENV{SITE_DIR}  || die 'SITE_DIR is not defined';
    
    unshift (@INC, $ENV{MKDOC_DIR});
};


sub __init__
{
    eval "use MKDoc";
    $@ and die $@;
    
    eval "use MKDoc::Handler::Initialize";
    $@ and die $@;

    MKDoc::Handler::Initialize::handler();
}


sub handler
{
    __init__();
    my $class = shift;
    my $path = shift;
    
    my $document_t = flo::Standard::table ('Document');
    my $document = $document_t->get (Full_Path => $path) or
       die "document $path could not be found";

    my $del_condition = new lib::sql::Condition;
    $del_condition->add ('Full_Path', 'LIKE', "$path/%");
    $document_t->delete ($del_condition);
    $document_t->delete (Full_Path => $path);
}


package main;
use strict;
use warnings;

my $path = shift (@ARGV) || die "Usage: $0 <path>";
MKDoc::Bin::Deltree->handler ($path);


1;
