#!/usr/bin/perl
use strict;
use warnings;
use Carp;

$ENV{MKDOC_DIR}   || croak 'Environment variable MKDOC_DIR is not defined';
$ENV{SERVER_NAME} || croak 'Environment variable SERVER_NAME is not defined';

unshift @INC, $ENV{MKDOC_DIR};
eval <<EOF;
    use MKDoc;
    use flo::Standard;      
EOF

croak $@ if (defined $@ and $@);
		       
MKDoc->init;

main();

sub main
{
    my $document_t = flo::Standard::table ('Document');
    my @full_paths = $document_t->select ( cols => 'Full_Path' )->fetch_all;
    print join "\n", map { $_->{Full_Path} } @full_paths;
    print "\n";
}


1;
