#!/usr/bin/perl
use strict;
use warnings;
use MKDoc;

# make sure SITE_DIR is set since MKDoc->init needs it
die "SITE_DIR isn't set.  Please source mksetenv.sh from an installed MKDoc site ".
  "and try again.\n" 
  unless $ENV{SITE_DIR};

# initialize MKDoc, needed for database connection
MKDoc->init;

my $dbh = lib::sql::DBH->get();

print "Creating the Document_TimeRange table if necessary...\n";
$dbh->do(<<END);
    CREATE TABLE IF NOT EXISTS Document_TimeRange (
      ID int(11)          NOT NULL auto_increment,
      Document_ID int(11) NOT NULL default '0',
      FromDate datetime   NOT NULL default '0000-00-00 00:00:00',
      ToDate datetime     NOT NULL default '0000-00-00 00:00:00',
      PRIMARY KEY   (ID),
      KEY DocIndex  (Document_ID),
      KEY FromIndex (FromDate),
      KEY ToIndex   (ToDate)
    ) TYPE=MyISAM
END
    
print "Creating the Document_Grp table if necessary...\n";
$dbh->do(<<END);
    CREATE TABLE IF NOT EXISTS Document_Grp (
      Document_ID int(11) NOT NULL default '0',
      Grp_ID int(11)      NOT NULL default '0',
      PRIMARY KEY                 (Document_ID,Grp_ID),
      KEY ReverseGrpDocumentIndex (Grp_ID,Document_ID)
    ) TYPE=MyISAM
END
    
print "Creating the Editor_Grp table if necessary...\n";
$dbh->do(<<END);
    CREATE TABLE IF NOT EXISTS Editor_Grp (
      Editor_ID int(11) NOT NULL default '0',
      Grp_ID int(11)    NOT NULL default '0',
      PRIMARY KEY               (Editor_ID,Grp_ID),
      KEY ReverseGrpEditorIndex (Grp_ID,Editor_ID)
    ) TYPE=MyISAM
END
    
print "Creating the Grp table if necessary...\n";
$dbh->do(<<END);
    CREATE TABLE IF NOT EXISTS Grp (
      ID int(11)            NOT NULL auto_increment,
      Name char(255)        default NULL,
      Description char(255) default NULL,
      PRIMARY KEY  (ID)
    ) TYPE=MyISAM
END

use Data::Dumper;
my $VAR1;
my $file;

print "Creating the Grp driver file...\n";
$VAR1 = bless( {
                 'unique' => {},
                 'pk' => [
                           'ID'
                         ],
                 'name' => 'Grp',
                 'cols' => [
                             {
                               'name' => 'ID',
                               'type' => bless( {
                                                  'not_null' => 1
                                                }, 'lib::sql::type::Int' )
                             },
                             {
                               'name' => 'Name',
                               'type' => bless( {
                                                  'size' => 255
                                                }, 'lib::sql::type::Char' )
                             },
                             {
                               'name' => 'Description',
                               'type' => bless( {
                                                  'size' => 255
                                                }, 'lib::sql::type::Char' )
                             }
                           ],
                 'index' => {},
                 'selectbox' => undef,
                 'ai' => 1,
                 'fk' => {}
               }, 'lib::sql::Table' );

$file = $ENV{SITE_DIR}.'/su/Grp.def';
open FP, ">$file";
print FP Dumper ($VAR1);
close FP;


print "Creating the Editor_Grp driver file...\n";
$VAR1 = bless( {
                 'unique' => {},
                 'pk' => [
                           'Editor_ID',
                           'Grp_ID'
                         ],
                 'name' => 'Editor_Grp',
                 'cols' => [
                             {
                               'name' => 'Editor_ID',
                               'type' => bless( {
                                                  'not_null' => 1
                                                }, 'lib::sql::type::Int' )
                             },
                             {
                               'name' => 'Grp_ID',
                               'type' => bless( {
                                                  'not_null' => 1
                                                }, 'lib::sql::type::Int' )
                             }
                           ],
                 'index' => {
                              'ReverseGrpEditorIndex' => [
                                                           'Grp_ID',
                                                           'Editor_ID'
                                                         ]
                            },
                 'selectbox' => undef,
                 'ai' => undef,
                 'fk' => {
                           'Grp' => {
                                      'Grp_ID' => 'ID'
                                    },
                           'Editor' => {
                                         'Editor_ID' => 'ID'
                                       }
                         }
               }, 'lib::sql::Table' );

$file = $ENV{SITE_DIR}.'/su/Editor_Grp.def';
open FP, ">$file";
print FP Dumper ($VAR1);
close FP;


print "Creating the Document_Grp driver file...\n";
$VAR1 = bless( {
                 'unique' => {},
                 'pk' => [
                           'Document_ID',
                           'Grp_ID'
                         ],
                 'name' => 'Document_Grp',
                 'cols' => [
                             {
                               'name' => 'Document_ID',
                               'type' => bless( {
                                                  'not_null' => 1
                                                }, 'lib::sql::type::Int' )
                             },
                             {
                               'name' => 'Grp_ID',
                               'type' => bless( {
                                                  'not_null' => 1
                                                }, 'lib::sql::type::Int' )
                             }
                           ],
                 'index' => {
                              'ReverseGrpDocumentIndex' => [
                                                             'Grp_ID',
                                                             'Document_ID'
                                                           ]
                            },
                 'selectbox' => undef,
                 'ai' => undef,
                 'fk' => {
                           'Grp' => {
                                      'Grp_ID' => 'ID'
                                    },
                           'Document' => {
                                           'Document_ID' => 'ID'
                                         }
                         }
               }, 'lib::sql::Table' );

$file = $ENV{SITE_DIR}.'/su/Document_Grp.def';
open FP, ">$file";
print FP Dumper ($VAR1);
close FP;


print "Creating the Document_TimeRange driver file...\n";
$VAR1 = bless( {
                 'unique' => {},
                 'pk' => [
                           'ID'
                         ],
                 'name' => 'Document_TimeRange',
                 'cols' => [
                             {
                               'name' => 'ID',
                               'type' => bless( {
                                                  'not_null' => 1
                                                }, 'lib::sql::type::Int' )
                             },
                             {
                               'name' => 'Document_ID',
                               'type' => bless( {
                                                  'not_null' => 1
                                                }, 'lib::sql::type::Int' )
                             },
                             {
                               'name' => 'FromDate',
                               'type' => bless( {
                                                  'not_null' => 1
                                                }, 'lib::sql::type::DateTime' )
                             },
                             {
                               'name' => 'ToDate',
                               'type' => bless( {
                                                  'not_null' => 1
                                                }, 'lib::sql::type::DateTime' )
                             }
                           ],
                 'index' => {
                              'DocIndex' => [
                                              'Document_ID'
                                            ],
                              'FromIndex' => [
                                               'FromDate'
                                             ],
                              'ToIndex' => [
                                             'ToDate'
                                           ]
                            },
                 'selectbox' => undef,
                 'ai' => 1,
                 'fk' => {
                           'Document' => {
                                           'Document_ID' => 'ID'
                                         }
                         }
               }, 'lib::sql::Table' );

$file = $ENV{SITE_DIR}.'/su/Document_TimeRange.def';
open FP, ">$file";
print FP Dumper ($VAR1);
close FP;


1;

