#!/usr/bin/perl
use strict;
use warnings;

use Getopt::Declare;
use MKDoc::XML::Stripper;

my $usage = q(
  [nocase] [strict]
  [mutex: --mkdoc16 --strict --transitional --frameset]

  XHTML Whitelist
  Allowable elements/attributes

  --mkdoc16		MKDoc 1.6 [required]
  --strict		XHTML 1.0 Strict [required]
  --transitional	XHTML 1.0 Transitional [required]
  --frameset		XHTML 1.0 Frameset [required]
);

my $arg = new Getopt::Declare($usage);

die if not defined $arg;

my $strip = new MKDoc::XML::Stripper;
my $content = '';

$strip->load_def('mkdoc16') if $arg->{'--mkdoc16'};
$strip->load_def('xhtml10strict') if $arg->{'--strict'};
$strip->load_def('xhtml10transitional') if $arg->{'--transitional'};
$strip->load_def('xhtml10frameset') if $arg->{'--frameset'};

while (<STDIN>)
{
  $content .= join('', $_);
}

print $strip->process_data($content);

die "$0: No output.\n"
  if ($content eq '');

